<?php
class PaymentGatewayController {
    public function __construct() {
        auth_guard();
    }

    public function index() {
        $data = [
            'title' => 'Payment Gateways',
            'gateways' => get_available_gateways()
        ];
        view('gateways_view', $data);
    }

    public function edit($slug) {
        if (empty($slug)) {
            header('Location: ' . APP_URL . '/admin/gateways');
            exit;
        }

        $gateway_info = get_gateway_info($slug);

        if (!$gateway_info) {
            die('Gateway not found');
        }

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $settings = $_POST['settings'] ?? [];
            update_gateway_settings($slug, $settings);
            $_SESSION['flash_message'] = $gateway_info['name'] . " settings updated successfully!";
            header('Location: ' . APP_URL . '/admin/gateways/edit/' . $slug);
            exit;
        }

        $data = [
            'title' => 'Edit Gateway: ' . $gateway_info['name'],
            'gateway' => $gateway_info,
            'settings' => get_gateway_settings($slug)
        ];
        view('gateway_edit_view', $data);
    }
}
